@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Cities</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        City List
        <span>
            <a href="{{ url('city/create') }}" class="btn btn-az-primary" style="float: right">
                <i class="fa-solid fa-plus"></i> Add new city </a>
        </span>
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div>
                <table id="example2" class="table table-striped">
                    <thead>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-20p">City Name</th>
                            <th class="wd-20p">City Name Urdu</th>
                            <th class="wd-20p">Action</th>
                        </tr>
                    </thead>
                    <tbody id="data-body">
                        @foreach ($cities as $key => $city)
                            <tr>
                                <td>{{ $key + 1 }}</td> <!-- Fixed increment issue -->
                                <td>{{ $city->city_name }}</td>
                                <td>{{ $city->city_name_urdu }}</td>
                                <td>
                                    <a class="btn rounded shadow-base" title="Edit City"
                                        href="{{ url('city/edit/' . Crypt::encrypt($city->id_city)) }}">
                                        <i class="text-primary fa-regular fa-pen-to-square"></i>
                                        <span class="text-primary">Edit</span>
                                    </a>
                                    <a class="btn rounded shadow-base" title="Delete City" data-toggle="modal"
                                        data-target="#deleteModal" data-id="{{ Crypt::encrypt($city->id_city) }}">
                                        <i class="text-danger fa-solid fa-trash-can"></i>
                                        <span class="text-danger">Remove</span>
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-20p">City Name</th>
                            <th class="wd-20p">City Name Urdu</th>
                            <th class="wd-20p">Action</th>
                        </tr>
                    </tfoot>
                </table>

                {{-- <table id="example2" class="table table-striped">
                    <thead>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-20p">City</th>
                            <th class="wd-20p">State Code</th>
                            <th class="wd-20p">Country Code</th>
                            <th class="wd-20p">Country</th>
                        </tr>
                    </thead>
                    <tbody id="data-body">
                    </tbody>
                    <tfoot>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-20p">City</th>
                            <th class="wd-20p">State Code</th>
                            <th class="wd-20p">Country Code</th>
                            <th class="wd-20p">Country</th>
                        </tr>
                    </tfoot>
                </table> --}}
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this city?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-secondary text-light" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(function() {
            oTable = $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'City List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'City List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'City List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'City List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    }
                ],
                responsive: true
            });
        });
        
        // $(document).ready(function() {
        //     $('#example2').DataTable({
        //         processing: true,
        //         serverSide: true,
        //         ajax: {
        //             url: '{{ route('get_cities_data') }}',
        //             type: 'GET',
        //         },
        //         columns: [{
        //                 data: 'id',
        //                 name: 'id'
        //             },
        //             {
        //                 data: 'name',
        //                 name: 'name'
        //             },
        //             {
        //                 data: 'state_id',
        //                 name: 'state_id'
        //             },
        //             {
        //                 data: 'state_code',
        //                 name: 'state_code'
        //             },
        //             {
        //                 data: 'country_name',
        //                 name: 'country_name'
        //             },


        //         ],
        //     });
        // });

        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('city/delete') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
@endpush
